////////////////////////////////////////////////////////////////////////////////
// Filename: Disc Reel.vs
////////////////////////////////////////////////////////////////////////////////

#define M_PI 3.1415926535897932384626433832795f
/////////////
// GLOBALS //
/////////////
cbuffer MatrixBuffer
{
	float Degrees; 
	float3 Padding;
	matrix worldMatrix;
	matrix viewMatrix;
	matrix projectionMatrix;
};


//////////////
// TYPEDEFS //
//////////////
struct VertexInputType
{
    float4 position : POSITION;
    float2 tex : TEXCOORD0;
};

struct PixelInputType
{
    float4	position : SV_POSITION;
    float2	tex : TEXCOORD0;
	float2	rotTex : TEXCOORD1;
	float2	rotAngle : TEXCOORD2;

};


////////////////////////////////////////////////////////////////////////////////
// Vertex Shader
////////////////////////////////////////////////////////////////////////////////
PixelInputType TextureVertexShader(VertexInputType input)
{
    PixelInputType output;

	// Change the position vector to be 4 units for proper matrix calculations.
    input.position.w = 1.0f;

	// Calculate the position of the vertex against the world, view, and projection matrices.
    output.position = mul(input.position, worldMatrix);
    output.position = mul(output.position, viewMatrix);
    output.position = mul(output.position, projectionMatrix);
    
	//Store the usual texture coordinates.
	output.tex = input.tex;

	//Calculate and store the counter rotated coordinates.
	float Radians = Degrees * (M_PI / 180.0f);
	output.rotTex = input.tex - float2(0.5f, 0.5f);
    output.rotTex = mul(float2x2(cos(Radians), sin(Radians), -sin(Radians), cos(Radians)), output.rotTex);
	output.rotTex += float2(0.5f, 0.5f);
	
	output.rotAngle.x = Degrees;
	output.rotAngle.y = Radians;

	// Store the texture coordinates for the pixel shader.
    return output;
}